<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\SupplierController;
use App\Http\Controllers\API\InvoiceController;
use App\Http\Controllers\API\DashboardController;
use App\Http\Controllers\API\UserCreditsController;
use App\Http\Controllers\API\BillingPackageController;
use App\Http\Controllers\API\BusinessController;
use App\Http\Controllers\API\ProvinceTaxRateController;
use App\Http\Controllers\API\BulkUploadController;
use App\Http\Controllers\API\PDFController;
use App\Http\Controllers\API\AdminController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return response()->json([
        'message' => 'Bata Invoicing API',
        'version' => '1.0.0',
        'status' => 'running'
    ]);
});

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| All API routes are prefixed with /api
|
*/

Route::prefix('api')->group(function () {
    
    // Public routes (no authentication required)
    Route::post('/auth/register', [AuthController::class, 'register']);
    Route::post('/auth/login', [AuthController::class, 'login']);
    Route::post('/auth/forgot-password', [AuthController::class, 'forgotPassword']);
    Route::post('/auth/reset-password', [AuthController::class, 'resetPassword']);
    
    // Protected routes (authentication required)
    Route::middleware('auth:api')->group(function () {
        
        // Authentication
        Route::get('/auth/me', [AuthController::class, 'me']);
        Route::post('/auth/logout', [AuthController::class, 'logout']);
        Route::post('/auth/refresh', [AuthController::class, 'refresh']);
        Route::post('/auth/verify-session', [AuthController::class, 'verifySession']);
        Route::post('/auth/increment-session', [AuthController::class, 'incrementSession']);
        Route::post('/auth/change-password', [AuthController::class, 'changePassword']);
        
        // Dashboard
        Route::get('/dashboard', [DashboardController::class, 'index']);
        
        // Suppliers
        Route::get('/suppliers', [SupplierController::class, 'index']);
        Route::post('/suppliers', [SupplierController::class, 'store']);
        Route::get('/suppliers/{id}', [SupplierController::class, 'show']);
        Route::put('/suppliers/{id}', [SupplierController::class, 'update']);
        Route::delete('/suppliers/{id}', [SupplierController::class, 'destroy']);
        
        // Invoices
        Route::get('/invoices', [InvoiceController::class, 'index']);
        Route::post('/invoices', [InvoiceController::class, 'store']);
        Route::get('/invoices/{id}', [InvoiceController::class, 'show']);
        Route::put('/invoices/{id}', [InvoiceController::class, 'update']);
        Route::delete('/invoices/{id}', [InvoiceController::class, 'destroy']);
        
        // User Credits
        Route::get('/user-credits', [UserCreditsController::class, 'index']);
        Route::post('/consume-credits', [UserCreditsController::class, 'consume']);
        
        // Billing Packages
        Route::get('/billing-packages', [BillingPackageController::class, 'index']);
        
        // Businesses
        Route::get('/businesses', [BusinessController::class, 'index']);
        Route::post('/businesses', [BusinessController::class, 'store']);
        Route::get('/businesses/{id}', [BusinessController::class, 'show']);
        Route::put('/businesses/{id}', [BusinessController::class, 'update']);
        Route::delete('/businesses/{id}', [BusinessController::class, 'destroy']);
        
        // Province Tax Rates
        Route::get('/province-tax-rates', [ProvinceTaxRateController::class, 'index']);
        
        // Bulk Uploads
        Route::get('/bulk-uploads', [BulkUploadController::class, 'index']);
        Route::post('/import-csv', [BulkUploadController::class, 'import']);
        
        // PDF Generation
        Route::post('/generate-pdf', [PDFController::class, 'generate']);
        
        // Admin routes (admin and saas_admin roles only)
        Route::middleware('role:admin,saas_admin')->group(function () {
            Route::get('/admin-settings', [AdminController::class, 'settings']);
            Route::get('/saas-users', [AdminController::class, 'saasUsers']);
            Route::get('/saas-invoices', [AdminController::class, 'saasInvoices']);
        });
    });
});
