<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('province_tax_rates', function (Blueprint $table) {
            $table->id();
            $table->string('province_name')->unique();
            $table->decimal('tax_rate', 5, 2);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            $table->index(['province_name']);
            $table->index(['is_active']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('province_tax_rates');
    }
};
