<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class PermissionServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Create default roles and permissions
        $this->createDefaultRolesAndPermissions();
    }

    /**
     * Create default roles and permissions.
     */
    private function createDefaultRolesAndPermissions(): void
    {
        // Create permissions
        $permissions = [
            'view_invoices',
            'create_invoices',
            'edit_invoices',
            'delete_invoices',
            'view_suppliers',
            'create_suppliers',
            'edit_suppliers',
            'delete_suppliers',
            'view_businesses',
            'create_businesses',
            'edit_businesses',
            'delete_businesses',
            'view_users',
            'manage_users',
            'view_admin_settings',
            'manage_admin_settings',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Create roles
        $userRole = Role::firstOrCreate(['name' => 'user']);
        $adminRole = Role::firstOrCreate(['name' => 'admin']);
        $saasAdminRole = Role::firstOrCreate(['name' => 'saas_admin']);

        // Assign permissions to user role
        $userRole->givePermissionTo([
            'view_invoices',
            'create_invoices',
            'edit_invoices',
            'delete_invoices',
            'view_suppliers',
            'create_suppliers',
            'edit_suppliers',
            'delete_suppliers',
            'view_businesses',
            'create_businesses',
            'edit_businesses',
            'delete_businesses',
        ]);

        // Assign permissions to admin role
        $adminRole->givePermissionTo([
            'view_invoices',
            'create_invoices',
            'edit_invoices',
            'delete_invoices',
            'view_suppliers',
            'create_suppliers',
            'edit_suppliers',
            'delete_suppliers',
            'view_businesses',
            'create_businesses',
            'edit_businesses',
            'delete_businesses',
            'view_users',
            'manage_users',
            'view_admin_settings',
            'manage_admin_settings',
        ]);

        // Assign permissions to saas_admin role
        $saasAdminRole->givePermissionTo([
            'view_invoices',
            'create_invoices',
            'edit_invoices',
            'delete_invoices',
            'view_suppliers',
            'create_suppliers',
            'edit_suppliers',
            'delete_suppliers',
            'view_businesses',
            'create_businesses',
            'edit_businesses',
            'delete_businesses',
            'view_users',
            'manage_users',
            'view_admin_settings',
            'manage_admin_settings',
        ]);
    }
}
