<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProvinceTaxRate extends Model
{
    use HasFactory;

    protected $fillable = [
        'province_name',
        'tax_rate',
        'is_active',
    ];

    protected $casts = [
        'tax_rate' => 'decimal:2',
        'is_active' => 'boolean',
    ];

    /**
     * Get the suppliers in this province.
     */
    public function suppliers()
    {
        return $this->hasMany(Supplier::class, 'province', 'province_name');
    }

    /**
     * Get the users in this province.
     */
    public function users()
    {
        return $this->hasMany(User::class, 'province', 'province_name');
    }

    /**
     * Scope a query to only include active tax rates.
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Get the formatted tax rate.
     */
    public function getFormattedTaxRateAttribute()
    {
        return number_format($this->tax_rate, 2) . '%';
    }
}
