<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CityFee extends Model
{
    use HasFactory;

    protected $fillable = [
        'city_name',
        'fee_amount',
        'is_active',
    ];

    protected $casts = [
        'fee_amount' => 'decimal:2',
        'is_active' => 'boolean',
    ];

    /**
     * Scope a query to only include active city fees.
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Get the formatted fee amount.
     */
    public function getFormattedFeeAttribute()
    {
        return '$' . number_format($this->fee_amount, 2);
    }
}
