<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BillingPackage extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'price',
        'credits',
        'is_active',
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'credits' => 'integer',
        'is_active' => 'boolean',
    ];

    /**
     * Get the user subscriptions for this package.
     */
    public function userSubscriptions()
    {
        return $this->hasMany(UserSubscription::class);
    }

    /**
     * Scope a query to only include active packages.
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Get the formatted price.
     */
    public function getFormattedPriceAttribute()
    {
        return '$' . number_format($this->price, 2);
    }

    /**
     * Get the price per credit.
     */
    public function getPricePerCreditAttribute()
    {
        return $this->credits > 0 ? $this->price / $this->credits : 0;
    }

    /**
     * Get the formatted price per credit.
     */
    public function getFormattedPricePerCreditAttribute()
    {
        return '$' . number_format($this->price_per_credit, 4);
    }
}
