<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\ProvinceTaxRate;
use Illuminate\Http\Request;

class ProvinceTaxRateController extends Controller
{
    /**
     * Display a listing of province tax rates.
     */
    public function index()
    {
        $taxRates = ProvinceTaxRate::active()->orderBy('province_name')->get();
        
        return response()->json([
            'success' => true,
            'data' => $taxRates
        ]);
    }
}
