<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Invoice;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class PDFController extends Controller
{
    /**
     * Generate PDF for invoice.
     */
    public function generate(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'invoice_id' => 'required|exists:invoices,id',
            'format' => 'nullable|string|in:A4,Letter',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 422);
        }

        $user = Auth::user();
        $invoiceId = $request->invoice_id;
        $format = $request->format ?? 'A4';
        
        // Verify invoice belongs to user
        $invoice = Invoice::forUser($user->id)
            ->with(['supplier', 'invoiceItems'])
            ->findOrFail($invoiceId);
        
        try {
            // Here you would implement the actual PDF generation logic
            // For now, just return success message
            
            // Example PDF generation using DomPDF (you'll need to install it)
            // $pdf = \PDF::loadView('pdfs.invoice', compact('invoice'));
            // $pdf->setPaper($format);
            // return $pdf->download('invoice-' . $invoice->invoice_number . '.pdf');
            
            return response()->json([
                'success' => true,
                'message' => 'PDF generated successfully',
                'data' => [
                    'invoice_id' => $invoice->id,
                    'invoice_number' => $invoice->invoice_number,
                    'format' => $format,
                    'download_url' => '/api/download-pdf/' . $invoice->id,
                ]
            ]);
            
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error generating PDF: ' . $e->getMessage()
            ], 500);
        }
    }
}
