<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\AdminSettings;
use App\Models\User;
use App\Models\SaaSInvoice;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminController extends Controller
{
    /**
     * Get admin settings.
     */
    public function settings()
    {
        $settings = AdminSettings::all();
        
        return response()->json([
            'success' => true,
            'data' => $settings
        ]);
    }

    /**
     * Get SaaS users.
     */
    public function saasUsers()
    {
        $users = User::with(['userCredits', 'userSubscriptions.billingPackage'])
            ->orderBy('created_at', 'desc')
            ->get();
        
        return response()->json([
            'success' => true,
            'data' => $users
        ]);
    }

    /**
     * Get SaaS invoices.
     */
    public function saasInvoices()
    {
        $invoices = SaaSInvoice::with('user')
            ->orderBy('created_at', 'desc')
            ->get();
        
        return response()->json([
            'success' => true,
            'data' => $invoices
        ]);
    }
}
