# Bata Invoicing System - Laravel Backend

A comprehensive Laravel 11 backend for the Bata Invoicing System, featuring JWT authentication, PostgreSQL database, and full API endpoints for invoice management, supplier management, credit systems, and more.

## 🚀 Features

- **JWT Authentication** with session versioning
- **PostgreSQL Database** with comprehensive schema
- **Invoice Management** with PDF generation
- **Supplier Management** with tax calculations
- **Credit System** with transaction tracking
- **Business Registration** with approval workflow
- **Bulk CSV Import/Export** functionality
- **Role-based Access Control** (User, Admin, SaaS Admin)
- **Session Management** with security features
- **PDF Generation** for invoices and reports
- **CSV Processing** for bulk operations

## 📋 Requirements

- PHP 8.2 or higher
- PostgreSQL 12 or higher
- Composer 2.0 or higher
- Laravel 11
- JWT Authentication
- Spatie Permission Package
- Maatwebsite Excel Package
- DomPDF Package

## 🛠️ Installation

### 1. Clone the Repository

```bash
git clone <repository-url>
cd bata-laravel-backend
```

### 2. Install Dependencies

```bash
composer install
```

### 3. Environment Configuration

Copy the environment file and configure your database:

```bash
cp .env.example .env
```

Update the `.env` file with your database credentials:

```env
APP_NAME="Bata Invoicing System"
APP_ENV=local
APP_KEY=
APP_DEBUG=true
APP_URL=http://localhost:8000

DB_CONNECTION=pgsql
DB_HOST=127.0.0.1
DB_PORT=5432
DB_DATABASE=bata_invoicing
DB_USERNAME=postgres
DB_PASSWORD=your_password

# JWT Configuration
JWT_SECRET=your_jwt_secret_here
JWT_TTL=60
JWT_REFRESH_TTL=20160
```

### 4. Generate Application Key

```bash
php artisan key:generate
```

### 5. Generate JWT Secret

```bash
php artisan jwt:secret
```

### 6. Run Database Migrations

```bash
php artisan migrate
```

### 7. Seed Initial Data (Optional)

```bash
php artisan db:seed
```

### 8. Start the Development Server

```bash
php artisan serve
```

## 🗄️ Database Schema

The system includes the following main tables:

- **users** - User accounts and profiles
- **suppliers** - Supplier information
- **invoices** - Invoice records
- **invoice_items** - Invoice line items
- **province_tax_rates** - Tax rates by province
- **user_credits** - User credit balances
- **credit_transactions** - Credit transaction history
- **billing_packages** - Subscription packages
- **user_subscriptions** - User subscriptions
- **businesses** - Business registrations
- **business_subscriptions** - Business subscriptions
- **city_fees** - City fee structures
- **bulk_invoice_uploads** - Bulk upload tracking
- **ntn_credit_claims** - NTN credit claims
- **credit_purchase_requests** - Credit purchase requests
- **saas_invoices** - SaaS billing invoices
- **admin_settings** - System configuration

## 🔐 Authentication

The system uses JWT (JSON Web Tokens) for authentication with the following features:

- **Login/Logout** endpoints
- **Token Refresh** functionality
- **Session Versioning** for security
- **Role-based Access Control**
- **Password Reset** functionality

### API Authentication Endpoints

```
POST /api/auth/login
POST /api/auth/register
POST /api/auth/logout
POST /api/auth/refresh
GET  /api/auth/me
POST /api/auth/verify-session
POST /api/auth/increment-session
POST /api/auth/forgot-password
POST /api/auth/reset-password
POST /api/auth/change-password
```

## 📊 API Endpoints

### Core Business Logic

- **Suppliers**: CRUD operations for supplier management
- **Invoices**: Complete invoice lifecycle management
- **Invoice Items**: Line item management
- **User Credits**: Credit system management
- **Businesses**: Business registration and approval
- **Bulk Operations**: CSV import/export functionality

### Admin Functions

- **User Management**: Admin user operations
- **System Settings**: Configuration management
- **Approval Workflows**: Business and credit approvals
- **Tax Rate Management**: Province tax rate configuration
- **Package Management**: Billing package configuration

## 🔧 Configuration

### JWT Configuration

JWT settings are configured in `config/jwt.php`:

- Token TTL: 60 minutes
- Refresh TTL: 14 days
- Algorithm: HS256
- Blacklist enabled for security

### Database Configuration

PostgreSQL is configured as the default database with:

- Connection pooling support
- SSL mode configuration
- Search path configuration

### File Upload Configuration

Configure file upload limits in your PHP settings:

```ini
upload_max_filesize = 10M
post_max_size = 10M
max_execution_time = 300
memory_limit = 256M
```

## 🚀 Deployment

### WHM cPanel Deployment

1. **Upload Files**: Upload the project files to your cPanel public_html directory
2. **Set Permissions**: Ensure proper file permissions (755 for directories, 644 for files)
3. **Configure Database**: Create PostgreSQL database and update `.env` file
4. **Install Dependencies**: Run `composer install --optimize-autoloader --no-dev`
5. **Run Migrations**: Execute `php artisan migrate --force`
6. **Generate Keys**: Run `php artisan key:generate` and `php artisan jwt:secret`
7. **Clear Cache**: Run `php artisan config:cache` and `php artisan route:cache`

### Environment Variables for Production

```env
APP_ENV=production
APP_DEBUG=false
APP_URL=https://yourdomain.com

DB_CONNECTION=pgsql
DB_HOST=localhost
DB_PORT=5432
DB_DATABASE=your_database
DB_USERNAME=your_username
DB_PASSWORD=your_password

JWT_SECRET=your_production_jwt_secret
JWT_TTL=60
JWT_REFRESH_TTL=20160

CACHE_DRIVER=redis
SESSION_DRIVER=redis
QUEUE_CONNECTION=redis
```

## 📁 Project Structure

```
bata-laravel-backend/
├── app/
│   ├── Http/Controllers/API/     # API Controllers
│   ├── Models/                   # Eloquent Models
│   └── Http/Middleware/          # Custom Middleware
├── config/                       # Configuration Files
├── database/
│   ├── migrations/               # Database Migrations
│   └── seeders/                  # Database Seeders
├── routes/                       # Route Definitions
├── storage/                      # File Storage
└── public/                       # Public Assets
```

## 🔒 Security Features

- **JWT Token Authentication**
- **Session Versioning**
- **Role-based Access Control**
- **Input Validation**
- **SQL Injection Protection**
- **CSRF Protection**
- **Rate Limiting**

## 📈 Performance Optimization

- **Database Indexing**
- **Query Optimization**
- **Caching Strategies**
- **Lazy Loading**
- **Eager Loading**

## 🧪 Testing

Run the test suite:

```bash
php artisan test
```

## 📝 API Documentation

The API follows RESTful conventions with consistent response formats:

### Success Response Format

```json
{
    "success": true,
    "message": "Operation successful",
    "data": {...}
}
```

### Error Response Format

```json
{
    "success": false,
    "message": "Error description",
    "errors": {...}
}
```

## 🤝 Contributing

1. Fork the repository
2. Create a feature branch
3. Commit your changes
4. Push to the branch
5. Create a Pull Request

## 📄 License

This project is licensed under the MIT License.

## 🆘 Support

For support and questions:

- Create an issue in the repository
- Contact the development team
- Check the documentation

## 🔄 Migration from Supabase

This Laravel backend is designed to replace your existing Supabase backend while maintaining all frontend endpoints. The migration process includes:

1. **Database Migration**: Convert Supabase schema to Laravel migrations
2. **API Compatibility**: Maintain identical endpoint structures
3. **Authentication**: Replace Supabase auth with JWT authentication
4. **Data Migration**: Import existing data from Supabase
5. **Testing**: Verify all functionality works as expected

## 📊 Monitoring and Logging

- **Application Logs**: Stored in `storage/logs/`
- **Database Logs**: PostgreSQL query logging
- **Performance Monitoring**: Response time tracking
- **Error Tracking**: Exception logging and monitoring

---

**Built with ❤️ for Bata Invoicing System**
