# 🔧 Laravel API Configuration

## 📋 **Environment Variables**

Update your `.env` file with these Laravel API settings:

```env
# Laravel API Configuration
VITE_LARAVEL_API_URL=http://localhost:8000/api

# For production, update to your domain:
# VITE_LARAVEL_API_URL=https://yourdomain.com/api

# Remove old Supabase variables:
# VITE_SUPABASE_URL=
# VITE_SUPABASE_ANON_KEY=
```

## 🚀 **API Base URL Configuration**

The frontend is now configured to use Laravel API endpoints. The base URL is set in:

**File**: `src/integrations/laravel/client.ts`
**Line**: `constructor(baseUrl: string = 'http://localhost:8000/api')`

## 🔗 **Available API Endpoints**

### **Authentication**
- `POST /api/auth/login` - User login
- `POST /api/auth/register` - User registration
- `POST /api/auth/logout` - User logout
- `GET /api/auth/me` - Get current user
- `POST /api/auth/refresh` - Refresh JWT token
- `POST /api/auth/verify-session` - Verify session version
- `POST /api/auth/increment-session` - Increment session version
- `POST /api/auth/forgot-password` - Password reset request
- `POST /api/auth/change-password` - Change password

### **Business Logic**
- `GET /api/suppliers` - Get user suppliers
- `POST /api/suppliers` - Create supplier
- `PUT /api/suppliers/{id}` - Update supplier
- `DELETE /api/suppliers/{id}` - Delete supplier

- `GET /api/invoices` - Get user invoices
- `POST /api/invoices` - Create invoice
- `PUT /api/invoices/{id}` - Update invoice
- `DELETE /api/invoices/{id}` - Delete invoice

- `GET /api/dashboard` - Get dashboard data
- `GET /api/user-credits` - Get user credits
- `POST /api/consume-credits` - Consume credits

- `GET /api/billing-packages` - Get billing packages
- `GET /api/businesses` - Get user businesses
- `POST /api/businesses` - Create business

- `GET /api/province-tax-rates` - Get province tax rates
- `GET /api/bulk-uploads` - Get bulk uploads
- `POST /api/import-csv` - Upload CSV file
- `POST /api/generate-pdf` - Generate PDF

### **Admin Endpoints**
- `GET /api/admin-settings` - Get admin settings
- `GET /api/saas-users` - Get SaaS users (admin only)
- `GET /api/saas-invoices` - Get SaaS invoices (admin only)

## 🔐 **JWT Token Storage**

JWT tokens are automatically stored in `localStorage` with the key `jwt_token`.

## 📱 **Frontend Integration**

The frontend now uses:
- **`LaravelAuthProvider`** instead of `AuthProvider`
- **`useLaravelAuth`** hook instead of `useAuth`
- **`laravelClient`** instead of `supabase`

## 🧪 **Testing**

1. **Start Laravel backend**: `php artisan serve`
2. **Frontend will connect to**: `http://localhost:8000/api`
3. **Test authentication**: Login/Register should work with Laravel
4. **Test data fetching**: Dashboard, suppliers, invoices should load from Laravel

## 🚨 **Troubleshooting**

### **CORS Issues**
Ensure Laravel CORS is configured in `config/cors.php`:

```php
return [
    'paths' => ['api/*'],
    'allowed_methods' => ['*'],
    'allowed_origins' => ['http://localhost:3000', 'http://localhost:5173'],
    'allowed_origins_patterns' => [],
    'allowed_headers' => ['*'],
    'exposed_headers' => [],
    'max_age' => 0,
    'supports_credentials' => false,
];
```

### **JWT Issues**
- Check if JWT secret is generated: `php artisan jwt:secret`
- Verify JWT configuration in `config/jwt.php`
- Check token expiration settings

### **Database Issues**
- Ensure PostgreSQL connection in `.env`
- Run migrations: `php artisan migrate`
- Check database permissions

## 📊 **Migration Status**

- ✅ **Authentication**: Complete (JWT tokens)
- ✅ **User Management**: Complete
- ✅ **Suppliers**: Complete
- ✅ **Invoices**: Complete
- ✅ **Dashboard**: Complete
- ✅ **Credits System**: Complete
- ✅ **File Uploads**: Complete
- ✅ **PDF Generation**: Complete
- ✅ **Admin Functions**: Complete

## 🎯 **Next Steps**

1. **Test all endpoints** with Postman/Insomnia
2. **Verify frontend functionality** with Laravel backend
3. **Deploy to production** when ready
4. **Import existing data** from Supabase to PostgreSQL
